/**
  @file             SM_RAL.h
  @version          0.1.0.0

  @brief            
  @details          

  Project           Stepper Motor Driver
  Platform          MPC5606S

  SWVersion         0.1.0


  (c) Copyright 2011 Freescale Semiconductor Inc.
  All Rights Reserved.
*/
/*==================================================================================================
==================================================================================================*/

#ifndef SM_RAL
    #define SM_RAL

/*==================================================================================================
                                       DEFINES AND MACROS
==================================================================================================*/

/* SMC module base address */
#define SMC_BASE_ADDR					0x400AB000u

/* Register offsets */
/* SMC Motor Controller Channel Control Register offset */
#define SMC_MCCC_OFFSET					0x10u
/* SMC Motor Controller Duty Cycle Register offset */
#define SMC_MCDC_OFFSET					0x20u

#define RAL_SMC_REG_MCCTL0 				SMC.MCCTL0.R			/* SMC control register 0 abstraction */
#define RAL_SMC_REG_MCCTL1 				SMC.MCCTL1.R			/* SMC control register 1 abstraction */
#define RAL_SMC_REG_MCPER 				SMC.MCPER.R			/* SMC period register abstraction */

#define RAL_SMC_BIT_MCCTL0_MCTOIF		0u					/* SMC MCCTL0_MCTOIF bit index */

#define RAL_SMC_CC_MCAM_MASK			0xCFu				/* SMC CC_MCAM dibit mask */
#define RAL_SMC_CC_MCAM_SHIFT			4u					/* SMC CC_MCAM shift to dibit */

/* SMC COS CC (x - sin/cos pair) */
#define RAL_MOTOR_CC_COS(x)				*(volatile uint8_t *)((SMC_BASE_ADDR + SMC_MCCC_OFFSET)\
                                        + ( 3u ) + (((x) & 0x06u) * 2u) - (((x) & 0x01u) * 2u))
/* SMC SIN CC (x - sin/cos pair) */		
#define RAL_MOTOR_CC_SIN(x)				*(volatile uint8_t *)((SMC_BASE_ADDR + SMC_MCCC_OFFSET)\
                                        + ( 2u ) + (((x) & 0x06u) * 2u) - (((x) & 0x01u) * 2u))
	
/* SMC COS DC (x - sin/cos pair) */	
#define RAL_MOTOR_DUTY_COS(x)			*(volatile uint16_t *)((SMC_BASE_ADDR + SMC_MCDC_OFFSET)\
                                        + ( 2u + ((x) << 2u)))
/* SMC SIN DC (x - sin/cos pair) */	
#define RAL_MOTOR_DUTY_SIN(x)			*(volatile uint16_t *)((SMC_BASE_ADDR + SMC_MCDC_OFFSET)\
                                        + ((x) << 2u))	

#define RAL_SSDX_REG_ITGACC				ITGACC.R			/* SSD integration accumulator register  abstraction */

#define RAL_SSDX_REG_IRQ				IRQ.R				/* SSD interrupt enable register abstraction */

#define RAL_SSDX_REG_CONTROL			CTRL.R			/* SSD control register abstraction */
#define RAL_SSDX_REG_PRESCALE			PRESCALE.R			/* SSD prescale and divider register abstraction */
#define RAL_SSDX_REG_BLNCNTLD			BLNCNTLD.R			/* SSD blanking counter load register abstraction */
#define RAL_SSDX_REG_ITGCNTLD			ITGCNTLD.R			/* SSD integration counter load register abstraction */

#define RAL_SSDX_CONTROL_STEP			CTRL.B.STEP		/* SSD CONTROL_STEP dibit abstraction */

#define RAL_SSDX_BIT_IRQ_ITGIF			14					/* SSD IRQ_ITGIF bit index */
#define RAL_SSDX_BIT_IRQ_ITGIE			6					/* SSD IRQ_ITGIE bit index */
#define RAL_SSDX_BIT_CONTROL_TRIG		15					/* SSD CONTROL_TRIG bit index */ 

#define RAL_STM0_REG_CIR(x)				STM_0.CHANNEL[(x)].CIR.R	
#define RAL_STM0_REG_CMP(x)				STM_0.CHANNEL[(x)].CMP.R	
#define RAL_STM0_BIT_CIR_CIF			0					/* STM Timer */

#define RAL_STM1_REG_CIR(x)				STM_1.CHANNEL[(x)-4].CIR.R	
#define RAL_STM1_REG_CMP(x)				STM_1.CHANNEL[(x)-4].CMP.R	
#define RAL_STM1_BIT_CIR_CIF			0					/* STM Timer */

#define RAL_RegWrite(val,reg)			(*(reg) = (val))	/* Writes "val" to register "reg" */
#define RAL_RegRead(reg) 				(*(reg))			/* Reads current value of "reg" register */

/* Sets bit on the "bit" index at the "reg" register */ 
#define RAL_RegBitSet(reg,bit)			(*(reg) = (*(reg)) | (1<<(bit)))

/* Clears bit on the "bit" index at the "reg" register */		 
#define RAL_RegBitClr(reg,bit)			(*(reg) = (*(reg)) & (~(1<<(bit))))

/* Reads bit on the "bit" index at the "reg" register */ 
#define RAL_RegBitRead(reg,bit)			(((*(reg)) >> (bit)) & 0x00000001)

/* Writes value "val" to the position of "reg" register defined by "mask" and "shift" */
#define RAL_RegMaskWrite(val,mask,shift,reg)		(*(reg) = *(reg) & (mask));\
													(*(reg) = *(reg) | ((val) << (shift)))

#endif	/* SM_RAL */